//Caption: Scilab code to implement Discrete Wavelet Transform
//Software version
//For: OS Windows7 and 8
//Scilab5.4.1 and above
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
//For: OS Ubuntu Linux 14.04 and above
//Scilab5.5.1 
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
//To read and write in the correct folder
//change the current directory in scilab console
clc;
clear;
close;
//Original Image
img = imread('Exp4cameraman.jpg');
figure(1)
ShowImage(img,'Original Image')
title('Original Image');
[p q] = size(img);
[CA,CH,CV,CD] = dwt2(double(img),'db1');//Compute 2D wavelet transform -daubcheis wavelet
figure(2)
ShowImage(uint8(CA),'LPF-LPF output')
title('LPF-LPF output')
figure(3)
ShowImage(uint8(CH),'LPF-HPF output')
title('LPF-HPF output')
figure(4)
ShowImage(uint8(CV),'HPF-LPF output')
title('HPF-LPF output')
figure(5)
ShowImage(uint8(CD),'HPF-HPF output')
title('HPF-HPF output')
img_inv = idwt2(CA,CH,CV,CD,'db1');
img_inv = uint8(img_inv);
figure(6)
ShowImage(img_inv,'Reconstructed Image')
title('Reconstructed Image')
